/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.entity.IOnProjectileHit;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.ai.SimpleRangedAttackGoal;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.phys.Vec3;

public class SmallFireballAttackGoal
extends SimpleRangedAttackGoal {
    public static ResourceLocation ID = ResourceLocation.tryParse((String)"brutalbosses:shootfireballs");

    public SmallFireballAttackGoal(Mob mob, IAIParams params) {
        super(mob, params);
    }

    @Override
    protected ResourceLocation getID() {
        return ID;
    }

    @Override
    protected void doRangedAttack(Projectile Projectile2, LivingEntity target) {
        Projectile2.remove(Entity.RemovalReason.DISCARDED);
        double xDiff = target.getX() - this.mob.getX();
        double yDiff = target.getY(0.5) - this.mob.getY(0.5);
        double zDiff = target.getZ() - this.mob.getZ();
        float distVariance = (float)(Math.sqrt(Math.sqrt(this.mob.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ()))) * 0.5);
        SmallFireball fireballEntity = new SmallFireball(this.mob.level(), (LivingEntity)this.mob, new Vec3(xDiff + this.mob.getRandom().nextGaussian() * (double)distVariance, yDiff, zDiff + this.mob.getRandom().nextGaussian() * (double)distVariance));
        fireballEntity.accelerationPower *= (double)this.params.speed;
        fireballEntity.setPos(this.mob.getX(), this.mob.getY() + (double)this.mob.getEyeHeight() - 0.5, this.mob.getZ());
        fireballEntity.setOwner((Entity)this.mob);
        ((IOnProjectileHit)fireballEntity).setMaxLifeTime(this.mob.level().getGameTime() + 400L);
        this.mob.level().addFreshEntity((Entity)fireballEntity);
    }

    @Override
    protected Projectile createProjectile() {
        SmallFireball fireballEntity = new SmallFireball(this.mob.level(), (LivingEntity)this.mob, Vec3.ZERO);
        ((IOnProjectileHit)fireballEntity).setMaxLifeTime(this.mob.level().getGameTime() + 800L);
        return fireballEntity;
    }
}

