/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.capability.BossCapEntity;
import com.brutalbosses.entity.capability.BossCapability;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class OutofCombatRegen
extends Goal {
    public static ResourceLocation ID = ResourceLocation.tryParse((String)"brutalbosses:aftercombatregen");
    private final Mob mob;
    private final float amount;
    private int combatTimer = 0;

    public OutofCombatRegen(Mob mob, IAIParams params) {
        this.amount = ((CombatParams)params).amount;
        this.mob = mob;
    }

    public boolean canUse() {
        LivingEntity target = this.mob.getTarget();
        if (target != null && target.isAlive()) {
            this.combatTimer = 600;
        } else if (this.combatTimer > 0) {
            --this.combatTimer;
        } else {
            this.combatTimer = 20;
            if (this.mob.getHealth() < this.mob.getMaxHealth()) {
                BossCapability bossCapability;
                this.mob.heal(this.amount);
                if (this.mob.getHealth() == this.mob.getMaxHealth() && (bossCapability = ((BossCapEntity)this.mob).getBossCap()) != null && bossCapability.isBoss()) {
                    bossCapability.getBossType().initGear((LivingEntity)this.mob);
                }
            }
        }
        return false;
    }

    public void stop() {
    }

    public void tick() {
    }

    public static class CombatParams
    extends IAIParams.DefaultParams {
        private float amount = 2.0f;
        private static final String AMOUNT = "amount";

        public CombatParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(AMOUNT)) {
                this.amount = jsonElement.get(AMOUNT).getAsFloat();
            }
            return this;
        }
    }
}

