/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.capability.BossCapEntity;
import java.util.EnumSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public class MeleeShieldAttackGoal
extends Goal {
    public static ResourceLocation ID = ResourceLocation.tryParse((String)"brutalbosses:shieldmelee");
    private final BossType bossType;
    protected final Mob mob;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private final double attackInterval;
    private long lastCanUseCheck;
    int shieldTicks = 0;

    public MeleeShieldAttackGoal(Mob entity, double speed) {
        this.mob = entity;
        this.speedModifier = speed;
        this.followingTargetEvenIfNotSeen = true;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
        this.bossType = ((BossCapEntity)this.mob).getBossCap().getBossType();
        this.attackInterval = this.bossType.getCustomAttributeValueOrDefault("attack_speed", 1.0f);
    }

    public boolean canUse() {
        long timeDiff = this.mob.level().getGameTime();
        if (timeDiff - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = timeDiff;
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity == null || !livingentity.isAlive()) {
            return false;
        }
        this.path = this.mob.getNavigation().createPath((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.mob.distanceToSqr(livingentity.getX(), livingentity.getY(), livingentity.getZ());
    }

    public boolean canContinueToUse() {
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.isAlive()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.getNavigation().isDone();
        }
        if (!this.mob.isWithinRestriction(livingentity.blockPosition())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.isSpectator() && !((Player)livingentity).isCreative();
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.path, this.speedModifier);
        this.mob.setAggressive(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void stop() {
        this.mob.setAggressive(false);
        this.mob.getNavigation().stop();
        this.mob.startUsingItem(InteractionHand.MAIN_HAND);
    }

    public void tick() {
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity == null) {
            return;
        }
        this.mob.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
        double d0 = this.mob.distanceToSqr(livingentity.getX(), livingentity.getY(), livingentity.getZ());
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if ((this.followingTargetEvenIfNotSeen || this.mob.getSensing().hasLineOfSight((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.distanceToSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.getRandom().nextFloat() < 0.05f)) {
            this.pathedTargetX = livingentity.getX();
            this.pathedTargetY = livingentity.getY();
            this.pathedTargetZ = livingentity.getZ();
            this.ticksUntilNextPathRecalculation = 4 + this.mob.getRandom().nextInt(7);
            if (d0 > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d0 > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.mob.getNavigation().moveTo((Entity)livingentity, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        this.checkAndPerformAttack(livingentity, d0);
    }

    protected void checkAndPerformAttack(LivingEntity target, double dist) {
        double d0 = this.getAttackReachSqr(target);
        if (dist <= d0 && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.mob.swing(InteractionHand.MAIN_HAND);
            this.mob.doHurtTarget((Entity)target);
        }
        if (this.shieldTicks == -20 && BrutalBosses.rand.nextInt(20) == 0) {
            this.mob.startUsingItem(InteractionHand.OFF_HAND);
            this.shieldTicks = BrutalBosses.rand.nextInt(10) + 20;
        }
        if (this.shieldTicks > -20) {
            --this.shieldTicks;
            if (this.shieldTicks == 0) {
                this.mob.stopUsingItem();
            }
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = (int)(20.0 / this.attackInterval);
    }

    protected double getAttackReachSqr(LivingEntity entity) {
        return (double)(this.mob.getBbWidth() * 2.0f * this.mob.getBbWidth() * 2.0f) * (double)this.bossType.getVisualScale();
    }
}

