/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonObject;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;

public class ChargeGoal
extends Goal {
    public static ResourceLocation ID = ResourceLocation.tryParse((String)"brutalbosses:charge");
    private static final AttributeModifier speedMod = new AttributeModifier(ResourceLocation.tryParse((String)"brutalbosses:speedbuff"), 2.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private final Mob mob;
    private ChargeParams params;
    private LivingEntity target = null;
    private int ticksToNextUpdate = 0;
    private boolean isCharging = false;

    public ChargeGoal(Mob mob, IAIParams params) {
        this.params = (ChargeParams)params;
        this.mob = mob;
    }

    public boolean canUse() {
        LivingEntity target = this.mob.getTarget();
        if (target != null && target.isAlive()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void stop() {
        this.target = null;
    }

    public void tick() {
        Path path;
        if (--this.ticksToNextUpdate > 0) {
            return;
        }
        double distSqr = this.mob.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
        this.ticksToNextUpdate = (int)Math.max(4.0, distSqr / 100.0);
        if (distSqr >= (double)this.params.minDistance && !this.isCharging && (path = this.mob.getNavigation().getPath()) != null) {
            this.isCharging = true;
            this.ticksToNextUpdate = (int)this.params.duration;
            if (!this.mob.getAttribute(Attributes.MOVEMENT_SPEED).hasModifier(speedMod.id())) {
                this.mob.getAttribute(Attributes.MOVEMENT_SPEED).addTransientModifier(speedMod);
            }
            this.mob.setSpeed((float)this.mob.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
            this.mob.level().playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), SoundEvents.CAT_HISS, this.mob.getSoundSource(), 1.0f, 1.0f);
            double d0 = -Mth.sin((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
            double d1 = Mth.cos((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
            if (this.mob.level() instanceof ServerLevel) {
                ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.mob.getX() + d0, this.mob.getY(0.5), this.mob.getZ() + d1, 20, d0, 0.0, d1, 0.0);
            }
            return;
        }
        if (this.isCharging) {
            this.isCharging = false;
            this.ticksToNextUpdate = (int)(this.params.interval + (float)(BrutalBosses.rand.nextInt(20) - 10));
            this.mob.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(speedMod);
            this.mob.setSpeed((float)this.mob.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
            this.mob.level().playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), SoundEvents.CAT_HISS, this.mob.getSoundSource(), 1.0f, 1.0f);
            double d0 = -Mth.sin((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
            double d1 = Mth.cos((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
            if (this.mob.level() instanceof ServerLevel) {
                ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.mob.getX() + d0, this.mob.getY(0.5), this.mob.getZ() + d1, 20, d0, 0.0, d1, 0.0);
            }
        }
    }

    public static class ChargeParams
    extends IAIParams.DefaultParams {
        private float minDistance = 3.0f;
        private float duration = 20.0f;
        private float interval = 200.0f;
        public static final String CHARGE_MINDIST = "mindist";
        public static final String CHARGE_DURATION = "duration";
        public static final String CHARGE_COOLDOWN = "interval";

        public ChargeParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(CHARGE_MINDIST)) {
                this.minDistance = jsonElement.get(CHARGE_MINDIST).getAsFloat();
            }
            if (jsonElement.has(CHARGE_DURATION)) {
                this.duration = jsonElement.get(CHARGE_DURATION).getAsFloat();
            }
            if (jsonElement.has(CHARGE_COOLDOWN)) {
                this.interval = jsonElement.get(CHARGE_COOLDOWN).getAsFloat();
            }
            return this;
        }
    }
}

